rm(list = ls())

library(raster)
library(rgdal)
library(sp)


##########################################################################################################################
rm(list = ls())
#loading summer evapotranspiration
sret<-raster("C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/Soil/SILVAE/sol/etrth6190_ete/hdr.adf")

#changing crs
grid<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Forest_area/Raster/area1.tif")

newproj<-"+init=epsg:3035"
pr3 <- projectExtent(grid, newproj)
sret3035<-projectRaster(yret, pr3)

writeRaster(sret3035, filename="C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/Soil/SILVAE/sol/etrth6190_ete/sret3035.tif", format="GTiff", overwrite=TRUE)


##########################################################################################################################
rm(list = ls())

#loading elevation
elev<-raster("C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/DB Alti/Merge/dbalti3035/hdr.adf")

#elevation: generate 1000m2 file 3035
grutil<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Forest_area/Raster/area1.tif")

elev<-aggregate(elev, fact=40, fun=mean)
newproj<-"+init=epsg:3035"
pr3 <- projectExtent(grutil, newproj)
elev<-projectRaster(elev, pr3)
writeRaster(elev, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/elev1000.tif", format="GTiff", overwrite=TRUE)



################################################################################################################################
rm(list = ls())

#loading ph data
ph<-raster("C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/Soil/SILVAE/carte_pH/ph_kg_2008/hdr.adf")

#changing crs
grid<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Forest_area/Raster/area1.tif")

newproj<-"+init=epsg:3035"
pr3 <- projectExtent(grid, newproj)
ph3035<-projectRaster(ph, pr3)

writeRaster(ph3035, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/ph.tif", format="GTiff", overwrite=TRUE)


################################################################################################################################
rm(list = ls())

#loading water stress data
wstress<-raster("C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/Soil/SILVAE/frex/de1000ete_moy/hdr.adf")

#changing crs
grid<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Forest_area/Raster/area1.tif")

newproj<-"+init=epsg:3035"
pr3 <- projectExtent(grid, newproj)
ws3035<-projectRaster(wstress, pr3)

writeRaster(ws3035, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/wstress.tif", format="GTiff", overwrite=TRUE)





##################################################################################################################################
#generate covarate raster stack
rm(list = ls())

area  <- raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Forest_area/Raster/area1.tif")
ser<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/ser.tif")
sret<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/sret.tif")
elev<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/elev1000.tif")
wstress<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/wstress.tif")
ph<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/ph.tif")

ser<-as.factor(ser)
covars<-stack(area,ser,elev, wstress, ph)
r<-writeRaster(covars, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Covariates/covars", format="GTiff", overwrite=TRUE)


